/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.util.date.daysadjustment;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.joda.time.DateTime;
import ru.ilb.meta.common.daysadjustment.Daysadjustment;
import ru.ilb.meta.common.daysadjustment.Holiday;
import ru.ilb.meta.common.daysadjustment.Unwantedday;
import ru.ilb.meta.common.daysadjustment.Weekend;
import ru.ilb.util.date.daysadjustment.HolidayImpl;
import ru.ilb.util.date.daysadjustment.UnwanteddayImpl;
import ru.ilb.util.date.daysadjustment.WeekendImpl;

public class DaysadjustmentImpl
extends Daysadjustment {
    public DaysadjustmentImpl(Daysadjustment da) throws IllegalArgumentException {
        int i;
        Calendar[] c;
        Calendar curr30 = Calendar.getInstance();
        curr30.add(1, 30);
        for (Holiday hd : da.getHoliday()) {
            c = new HolidayImpl(hd).getDates(curr30);
            for (i = 0; i < c.length; ++i) {
                this.getHoliday().add(new HolidayImpl((GregorianCalendar)c[i]));
            }
        }
        for (Weekend we : da.getWeekend()) {
            c = new WeekendImpl(we).getDates(curr30);
            for (i = 0; i < c.length; ++i) {
                while (this.isFreeDay(c[i])) {
                    c[i].add(5, 1);
                }
                this.getWeekend().add(new WeekendImpl((GregorianCalendar)c[i]));
            }
        }
        for (Unwantedday ud : da.getUnwantedday()) {
            this.getUnwantedday().add(new UnwanteddayImpl(ud));
        }
    }

    public boolean isWeekend(DateTime datetime) {
        return this.isWeekend(datetime.toGregorianCalendar());
    }

    public boolean isWeekend(Calendar gc) {
        if (gc != null) {
            for (Weekend we : this.getWeekend()) {
                if (!(we.getRfc3339Value() != null ? ((WeekendImpl)we).getDateEntity().inRange(gc) : we.getDateValue() != null && we.getDateValue().get(1) == gc.get(1) && we.getDateValue().get(2) == gc.get(2) && we.getDateValue().get(5) == gc.get(5))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHoliday(DateTime datetime) {
        return this.isHoliday(datetime.toGregorianCalendar());
    }

    public boolean isHoliday(Calendar gc) {
        if (gc != null) {
            for (Holiday hd : this.getHoliday()) {
                if (!(hd.getRfc3339Value() != null ? ((HolidayImpl)hd).getDateEntity().inRange(gc) : hd.getDateValue() != null && hd.getDateValue().get(1) == gc.get(1) && hd.getDateValue().get(2) == gc.get(2) && hd.getDateValue().get(5) == gc.get(5))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUnwantedday(DateTime datetime) {
        return this.isUnwantedday(datetime.toGregorianCalendar());
    }

    public boolean isUnwantedday(Calendar gc) {
        if (gc != null) {
            for (Unwantedday ud : this.getUnwantedday()) {
                if (!(ud.getRfc3339Value() != null ? ((UnwanteddayImpl)ud).getDateEntity().inRange(gc) : ud.getDateValue() != null && ud.getDateValue().get(1) == gc.get(1) && ud.getDateValue().get(2) == gc.get(2) && ud.getDateValue().get(5) == gc.get(5))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFreeDay(Calendar gc) {
        return this.isHoliday(gc) || this.isUnwantedday(gc) || this.isWeekend(gc);
    }
}

