/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.util.date.daysadjustment;

import java.util.Calendar;
import java.util.GregorianCalendar;
import ru.ilb.common.rfc3339.DateEntity;
import ru.ilb.meta.common.daysadjustment.Holiday;

public class HolidayImpl
extends Holiday {
    private DateEntity _value;

    public HolidayImpl(Holiday hd) throws IllegalArgumentException {
        if (hd.getRfc3339Value() != null) {
            this.setRfc3339Value(hd.getRfc3339Value());
            this._value = DateEntity.parse(hd.getRfc3339Value(), DateEntity.PRECISION_DAY);
        } else if (hd.getDateValue() != null) {
            this.setDateValue(hd.getDateValue());
            this._value = new DateEntity(hd.getDateValue(), (Integer)DateEntity.PRECISION_DAY);
        }
    }

    public HolidayImpl(String rfc3339) throws IllegalArgumentException {
        this.setRfc3339Value(rfc3339);
        this._value = DateEntity.parse(rfc3339, DateEntity.PRECISION_DAY);
    }

    public HolidayImpl(GregorianCalendar calendar) {
        this.setDateValue(calendar);
        this._value = new DateEntity(calendar, (Integer)DateEntity.PRECISION_DAY);
    }

    public DateEntity getDateEntity() {
        return this._value;
    }

    public Calendar[] getDates(Calendar limit) {
        return this._value.getDates(limit);
    }
}

