/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.util.date.daysadjustment;

import java.util.Calendar;
import java.util.GregorianCalendar;
import ru.ilb.common.rfc3339.DateEntity;
import ru.ilb.meta.common.daysadjustment.Weekend;

public class WeekendImpl
extends Weekend {
    private DateEntity _value;

    public WeekendImpl(Weekend we) throws IllegalArgumentException {
        if (we.getRfc3339Value() != null) {
            this.setRfc3339Value(we.getRfc3339Value());
            this._value = DateEntity.parse(we.getRfc3339Value(), DateEntity.PRECISION_DAY);
        } else if (we.getDateValue() != null) {
            this.setDateValue(we.getDateValue());
            this._value = new DateEntity(we.getDateValue(), (Integer)DateEntity.PRECISION_DAY);
        }
    }

    public WeekendImpl(String rfc3339) throws IllegalArgumentException {
        this.setRfc3339Value(rfc3339);
        this._value = DateEntity.parse(rfc3339, DateEntity.PRECISION_DAY);
    }

    public WeekendImpl(GregorianCalendar calendar) {
        this.setDateValue(calendar);
        this._value = new DateEntity(calendar, (Integer)DateEntity.PRECISION_DAY);
    }

    public DateEntity getDateEntity() {
        return this._value;
    }

    public Calendar[] getDates(Calendar limit) {
        return this._value.getDates(limit);
    }
}

