/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.aspect.statelogger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import ru.ilb.common.aspect.statelogger.BaseStateLogger;

public abstract class StateFileLogger
extends BaseStateLogger {
    private String fileName;
    private File file;

    @Override
    public void controller(String controller) {
        this.fileName = controller;
        super.controller(controller);
    }

    private boolean initFile() {
        this.file = new File(this.fileName);
        try {
            if (!this.file.exists()) {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            return true;
        }
        catch (IOException ex) {
            LOG.error("StateFileLogger: \u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0444\u0430\u0439\u043b\u0430 " + this.fileName, (Throwable)ex);
            return false;
        }
    }

    public void saveToFile(String info) {
        if (this.initFile()) {
            try (FileWriter writer = new FileWriter(this.file.getAbsoluteFile(), true);){
                writer.write(info + "\n");
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                LOG.error("StateFileLogger: \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 " + this.fileName, (Throwable)ex);
            }
        }
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }
}

