/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.aspect.mail;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.aspectj.lang.JoinPoint;
import org.springframework.stereotype.Component;

@Component
public class ServerAdminNotifier {
    private String getServerAdmin() {
        String server_admin = null;
        if (server_admin == null) {
            try {
                InitialContext initCtx = new InitialContext();
                Context envCtx = (Context)initCtx.lookup("java:comp/env");
                server_admin = (String)envCtx.lookup("SERVER_ADMIN");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (server_admin == null) {
            server_admin = System.getProperty("SERVER_ADMIN");
        }
        if (server_admin == null) {
            server_admin = System.getenv("SERVER_ADMIN");
        }
        if (server_admin == null) {
            server_admin = "root";
        }
        return server_admin;
    }

    private String getMailMsg(JoinPoint joinPoint, Exception ex) {
        String mailMsg = "";
        try {
            String methodName = joinPoint.getSignature().getName();
            String threadid = Thread.currentThread().getName();
            String uuid = UUID.randomUUID().toString();
            String cause = ex.getCause() == null ? ex.getClass().getName() : ex.getCause().getClass().getName();
            String outMess = ex.getMessage();
            if (outMess == null) {
                outMess = "";
            }
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            String trace = writer.toString();
            int line2 = trace.indexOf("\n");
            mailMsg = "To: " + this.getServerAdmin() + "\n" + "Subject: [JAVA FATAL ERROR] in " + methodName + ": " + threadid + "\n" + "Content-Type: text/plain; charset=UTF-8\n\n" + cause + ": " + outMess + "\n" + threadid + " " + uuid + "\n" + (line2 < 0 ? trace : trace.substring(line2 + 1));
        }
        catch (Throwable ex_) {
            Logger.getLogger(ServerAdminNotifier.class.getName()).log(Level.SEVERE, "error constructing mailMsg", ex_);
        }
        return mailMsg;
    }

    private void sendMail(String mailMsg) {
        try {
            Process p = Runtime.getRuntime().exec("/usr/sbin/sendmail -t -oi");
            OutputStream o = p.getOutputStream();
            o.write(mailMsg.getBytes("UTF-8"));
            o.flush();
            o.close();
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new Exception("ServerAdminNotifier exitValue=" + p.exitValue());
            }
        }
        catch (Exception e) {
            System.out.println("ServerAdminNotifier failed: " + e.getMessage() + "\n" + mailMsg);
        }
    }

    public void sendMail(JoinPoint joinPoint, Exception exp) {
        this.sendMail(this.getMailMsg(joinPoint, exp));
    }
}

