/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.aspect.aspect;

import javax.annotation.PostConstruct;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.ilb.common.aspect.annotation.UnderLoggerControl;
import ru.ilb.common.aspect.mail.ServerAdminNotifier;
import ru.ilb.common.aspect.statelogger.BaseStateLogger;
import ru.ilb.common.aspect.statelogger.StateLoggerFactory;

@Aspect
@Component
public class UnderLoggerControlAspect {
    protected static final Logger LOG = LoggerFactory.getLogger(UnderLoggerControlAspect.class);
    @Autowired
    private StateLoggerFactory stateLoggerFactory;
    @Autowired
    private ServerAdminNotifier serverAdminNotifier;

    @Around(value="@annotation(underLoggerControl)")
    public Object underLoggerControlAdvice(ProceedingJoinPoint proceedingJoinPoint, UnderLoggerControl underLoggerControl) throws Throwable {
        BaseStateLogger stateLogger = this.stateLoggerFactory.getStateLogger(underLoggerControl.controller(), underLoggerControl.loggerClass());
        if (stateLogger != null) {
            stateLogger.start();
            stateLogger.working(0L, null);
        }
        Object value = null;
        try {
            value = proceedingJoinPoint.proceed();
        }
        catch (Throwable e) {
            if (stateLogger != null) {
                stateLogger.working(-1L, e.getMessage());
            }
            throw e;
        }
        if (stateLogger != null) {
            stateLogger.end();
        }
        return value;
    }

    @AfterThrowing(value="@annotation(underLoggerControl)", throwing="exp")
    public void underLoggerControlAfterThrowing(JoinPoint joinPoint, Exception exp, UnderLoggerControl underLoggerControl) {
        if (underLoggerControl.autoAdminExceptionNotification()) {
            this.serverAdminNotifier.sendMail(joinPoint, exp);
        }
    }

    @PostConstruct
    public void init() {
        LOG.info("Initialazing UnderLoggerControlAspect");
    }
}

