/*
 * Copyright 2018 shadrin_nv.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ru.ilb.common.aspect.autoconfig;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.ilb.common.aspect.aspect.UnderLoggerControlAspect;
import ru.ilb.common.aspect.mail.ServerAdminNotifier;
import ru.ilb.common.aspect.statelogger.StateLoggerFactory;

/**
 *
 * @author shadrin_nv
 */
@Configuration
@Import({UnderLoggerControlAspect.class})
public class UnderLoggerControlConfig {

    @Bean
    public StateLoggerFactory stateLoggerFactory() {
        return new StateLoggerFactory();
    }

    @Bean
    public ServerAdminNotifier serverAdminNotifier() {
        return new ServerAdminNotifier();
    }
}
