/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.aspect.statelogger;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import ru.ilb.common.aspect.statelogger.StateFileLogger;

public class ZabbixStateLogger
extends StateFileLogger {
    private static final String ZABBIX_LOG_FORMAT = "%s:::%s:::%s:::%s";
    private static final String START = "START";
    private static final String WORKING = "WORKING";
    private static final String END = "END";

    @Override
    public void controller(String controller) {
        controller = System.getProperty("catalina.base") + "/logs/zabix/" + controller + ".log";
        super.controller(controller);
    }

    @Override
    public void start() {
        this.saveToFile(this.getZabbixLogFormattedString(START, null, null));
    }

    @Override
    public void working(Long errorCode, String msg) {
        this.saveToFile(this.getZabbixLogFormattedString(WORKING, errorCode, msg));
    }

    @Override
    public void end() {
        this.saveToFile(this.getZabbixLogFormattedString(END, null, null));
    }

    private String getZabbixLogFormattedString(String state, Long errorCode, String msg) {
        return String.format(ZABBIX_LOG_FORMAT, DateTimeFormatter.ISO_DATE_TIME.format(LocalDateTime.now()), state, errorCode == null ? 0L : errorCode, msg == null ? "" : msg);
    }
}

