/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxb.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public final class JaxbUtil {
    private static final String MEDIA_TYPE = "eclipselink.media-type";
    private static final String JSON_INCLUDE_ROOT = "eclipselink.json.include-root";

    private JaxbUtil() {
    }

    public static <T> T unmarshal(JAXBContext jaxbContext, String string, Class<T> type, String mediaType) {
        return JaxbUtil.unmarshal(jaxbContext, new StreamSource(new StringReader(string)), type, mediaType);
    }

    public static <T> T unmarshal(JAXBContext jaxbContext, Source source, Class<T> type, String mediaType) {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            if (unmarshaller.getClass().getName().contains("eclipse")) {
                unmarshaller.setProperty(MEDIA_TYPE, (Object)mediaType);
                unmarshaller.setProperty(JSON_INCLUDE_ROOT, (Object)false);
            }
            Object unmarshal = type != null ? unmarshaller.unmarshal(source, type) : unmarshaller.unmarshal(source);
            unmarshal = JAXBIntrospector.getValue((Object)unmarshal);
            return (T)unmarshal;
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String marshal(JAXBContext jaxbContext, Object object, String mediaType) {
        StringWriter sw = new StringWriter();
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (marshaller.getClass().getName().contains("eclipse")) {
                marshaller.setProperty(MEDIA_TYPE, (Object)mediaType);
                if ("application/json".equals(mediaType)) {
                    marshaller.setProperty(JSON_INCLUDE_ROOT, (Object)false);
                }
            }
            marshaller.marshal(object, (Writer)sw);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
        return sw.toString();
    }

    public static <T> List<T> unmarshalCollection(JAXBContext jaxbContext, Source source, Class<T> type, String mediaType) {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            if (unmarshaller.getClass().getName().contains("eclipse")) {
                unmarshaller.setProperty(MEDIA_TYPE, (Object)mediaType);
                if ("application/json".equals(mediaType)) {
                    unmarshaller.setProperty(JSON_INCLUDE_ROOT, (Object)false);
                }
            }
            Collection tmp = (Collection)unmarshaller.unmarshal(source, type).getValue();
            for (Object element : tmp) {
                result.add(JAXBIntrospector.getValue(element));
            }
            return result;
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }
}

