/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.rs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.UUID;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import ru.ilb.common.rs.UUIDConverter;

@Provider
public class UUIDConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType == UUID.class) {
            return new UUIDParamConverter();
        }
        return null;
    }

    private static class UUIDParamConverter
    implements ParamConverter<UUID> {
        private UUIDParamConverter() {
        }

        public UUID fromString(String s) {
            return UUIDConverter.parseUUID(s);
        }

        public String toString(UUID arg0) {
            return UUIDConverter.printUUID(arg0);
        }
    }
}

