/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.exceptionhandler;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.validation.ResponseConstraintViolationException;

@Provider
public class ValidationExceptionMapper
implements ExceptionMapper<ValidationException> {
    private static final Logger LOG = LogUtils.getL7dLogger(ValidationExceptionMapper.class);
    private boolean addMessageToResponse;

    public Response toResponse(ValidationException exception) {
        Response.Status errorStatus = Response.Status.INTERNAL_SERVER_ERROR;
        StringBuilder responseBody = new StringBuilder(512);
        if (exception instanceof ConstraintViolationException) {
            ConstraintViolationException constraint = (ConstraintViolationException)exception;
            for (ConstraintViolation violation : constraint.getConstraintViolations()) {
                String message = this.getMessage(violation);
                LOG.log(Level.WARNING, message);
                if (!this.addMessageToResponse) continue;
                responseBody.append(message).append("\n");
            }
            if (!(constraint instanceof ResponseConstraintViolationException)) {
                errorStatus = Response.Status.BAD_REQUEST;
            }
        }
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder((Response.Status)errorStatus);
        if (this.addMessageToResponse) {
            rb.entity((Object)responseBody.toString());
        }
        return rb.build();
    }

    String getMessage(ConstraintViolation<?> violation) {
        String message = violation.getRootBeanClass().getSimpleName() + "." + violation.getPropertyPath() + ": " + violation.getMessage();
        return message;
    }

    public void setAddMessageToResponse(boolean addMessageToResponse) {
        this.addMessageToResponse = addMessageToResponse;
    }
}

