/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class ReplaceOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    String encoding = "UTF-8";
    String regex;
    String replacement;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public ReplaceOutInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) throws Fault {
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        CachedStream cs = new CachedStream();
        message.setContent(OutputStream.class, (Object)cs);
        message.getInterceptorChain().doIntercept(message);
        try {
            cs.flush();
            CachedOutputStream csnew = (CachedOutputStream)message.getContent(OutputStream.class);
            String contents = IOUtils.toString((InputStream)csnew.getInputStream());
            String replaced = contents.replaceAll(this.regex, this.replacement);
            os.write(replaced.getBytes(Charset.forName(this.encoding)));
            os.flush();
            message.setContent(OutputStream.class, (Object)os);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private class CachedStream
    extends CachedOutputStream {
        protected void doFlush() throws IOException {
            this.currentStream.flush();
        }

        protected void doClose() throws IOException {
        }

        protected void onWrite() throws IOException {
        }
    }
}

