/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.exceptionhandler;

import java.io.InputStream;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class WebApplicationExceptionHandler
implements ExceptionMapper<WebApplicationException> {
    private static final Logger LOG = Logger.getLogger(WebApplicationExceptionHandler.class.getName());

    public Response toResponse(WebApplicationException ex) {
        int responseStatus = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        String outMess = ex.getMessage();
        try {
            Response r = ex.getResponse();
            if (r != null && r.getEntity() != null && r.getEntity() instanceof InputStream) {
                outMess = new Scanner((InputStream)r.getEntity(), "UTF-8").useDelimiter("\\A").next();
            }
            responseStatus = ex.getResponse().getStatus();
        }
        catch (Throwable ex_) {
            LOG.log(Level.SEVERE, "error on getting  addinional exception info", ex_);
        }
        if (outMess == null || outMess.isEmpty()) {
            outMess = ex.toString();
        }
        LOG.log(Level.WARNING, outMess, (Throwable)ex);
        return Response.status((int)responseStatus).entity((Object)outMess).type("text/plain").build();
    }
}

