/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.exceptionhandler;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.message.Message;
import ru.ilb.common.jaxrs.exceptionhandler.CustomResponseStatus;

@Provider
public class WebApplicationExceptionHandler
implements ExceptionMapper<WebApplicationException> {
    private static final Logger LOG = Logger.getLogger(WebApplicationExceptionHandler.class.getName());

    public Response toResponse(WebApplicationException ex) {
        int responseStatus = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        String outMess = ex.getMessage();
        Response r = ex.getResponse();
        try {
            Message m;
            if (r != null && r.getEntity() != null) {
                outMess = (String)r.readEntity(String.class);
            }
            if (ex instanceof ClientErrorException && r instanceof ResponseImpl && (m = ((ResponseImpl)r).getOutMessage()) != null && m.get((Object)"org.apache.cxf.request.uri") != null) {
                outMess = outMess + System.lineSeparator() + "Request URI: " + m.get((Object)"org.apache.cxf.request.uri");
            }
            responseStatus = ex.getResponse().getStatus();
        }
        catch (Throwable ex_) {
            LOG.log(Level.SEVERE, "error on getting  addinional exception info", ex_);
        }
        if (outMess == null || outMess.isEmpty()) {
            outMess = ex.toString();
        }
        LOG.log(Level.WARNING, outMess, (Throwable)ex);
        Object status = Response.Status.fromStatusCode((int)responseStatus);
        if (status == null) {
            status = new CustomResponseStatus(responseStatus, outMess);
        }
        return Response.status((Response.StatusType)status).entity((Object)outMess).type("text/plain").build();
    }
}

