/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.jaxb;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

@Provider
public class JaxbContextResolver
implements ContextResolver<JAXBContext> {
    private static final Logger LOG = Logger.getLogger(JaxbContextResolver.class.getName());
    protected Map<String, Object> contextProperties;
    protected final Map<String, JAXBContext> packageContexts = new HashMap<String, JAXBContext>();
    protected final Map<Class<?>, JAXBContext> classContexts = new HashMap();
    protected Class<?>[] extraClass;

    public void setContextProperties(Map<String, Object> contextProperties) {
        this.contextProperties = contextProperties;
    }

    public void setExtraClass(Class<?>[] extraClass) {
        this.extraClass = extraClass;
    }

    public JAXBContext getContext(Class<?> type) {
        try {
            return this.getJAXBContext(type);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getJAXBContext(Class<?> type) throws JAXBException {
        Map<Class<?>, JAXBContext> map = this.classContexts;
        synchronized (map) {
            JAXBContext context = this.classContexts.get(type);
            if (context != null) {
                return context;
            }
        }
        JAXBContext context = this.getPackageContext(type);
        return context != null ? context : this.getClassContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getClassContext(Class<?> type) throws JAXBException {
        Map<Class<?>, JAXBContext> map = this.classContexts;
        synchronized (map) {
            JAXBContext context = this.classContexts.get(type);
            if (context == null) {
                Class[] classes = null;
                if (this.extraClass != null) {
                    classes = new Class[this.extraClass.length + 1];
                    classes[0] = type;
                    System.arraycopy(this.extraClass, 0, classes, 1, this.extraClass.length);
                } else {
                    classes = new Class[]{type};
                }
                context = JAXBContext.newInstance((Class[])classes, this.contextProperties);
                this.classContexts.put(type, context);
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getPackageContext(Class<?> type) throws JAXBException {
        if (type == null || type == JAXBElement.class) {
            return null;
        }
        Map<String, JAXBContext> map = this.packageContexts;
        synchronized (map) {
            String packageName = JaxbContextResolver.getPackageName(type);
            JAXBContext context = this.packageContexts.get(packageName);
            if (context == null) {
                try {
                    if (type.getClassLoader() != null && this.objectFactoryOrIndexAvailable(type)) {
                        String contextName = packageName;
                        if (this.extraClass != null) {
                            StringBuilder sb = new StringBuilder(contextName);
                            for (Class<?> extra : this.extraClass) {
                                String extraPackage = JaxbContextResolver.getPackageName(extra);
                                if (extraPackage.equals(packageName)) continue;
                                sb.append(":").append(extraPackage);
                            }
                            contextName = sb.toString();
                        }
                        context = JAXBContext.newInstance((String)contextName, (ClassLoader)type.getClassLoader(), this.contextProperties);
                        this.packageContexts.put(packageName, context);
                    }
                }
                catch (JAXBException ex) {
                    LOG.log(Level.FINE, "Error creating a JAXBContext using ObjectFactory : {0}", ex.getMessage());
                    return null;
                }
            }
            return context;
        }
    }

    protected boolean objectFactoryOrIndexAvailable(Class<?> type) {
        return type.getResource("ObjectFactory.class") != null || type.getResource("jaxb.index") != null;
    }

    static String getPackageName(String className) {
        int pos = className.lastIndexOf(46);
        if (pos != -1) {
            return className.substring(0, pos);
        }
        return "";
    }

    public static String getPackageName(Class<?> clazz) {
        String className = clazz.getName();
        if (className.startsWith("[L")) {
            className = className.substring(2);
        }
        return JaxbContextResolver.getPackageName(className);
    }
}

