/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import ru.ilb.common.jaxrs.io.ByteArrayInOutStream;

public class ReplaceOutInterceptor
implements WriterInterceptor {
    String encoding = "UTF-8";
    Map<String, String> replacements;
    MediaType mediaType = new MediaType();

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setReplacements(Map<String, String> replacements) {
        this.replacements = replacements;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = JAXRSUtils.toMediaType((String)mediaType);
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        if (this.replacements != null && this.mediaType.isCompatible(context.getMediaType())) {
            OutputStream os = context.getOutputStream();
            ByteArrayInOutStream out = new ByteArrayInOutStream();
            context.setOutputStream((OutputStream)out);
            context.proceed();
            String contents = IOUtils.toString((InputStream)out.getInputStream());
            for (Map.Entry<String, String> keyValue : this.replacements.entrySet()) {
                contents = contents.replaceAll(keyValue.getKey(), keyValue.getValue());
            }
            os.write(contents.getBytes(Charset.forName(this.encoding)));
            os.flush();
        } else {
            context.proceed();
        }
    }
}

