/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.exceptionhandler;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.message.Message;
import ru.ilb.common.jaxrs.exceptionhandler.CustomResponseStatus;

@Provider
public class WebApplicationExceptionHandler
implements ExceptionMapper<WebApplicationException> {
    private static final Logger LOG = Logger.getLogger(WebApplicationExceptionHandler.class.getName());
    private final String UNCLASSIFIABLE_SERVER_ERROR_TEXT = "Unclassifiable server error";
    private final int CLIENT_WEB_ERROR_START = 450;
    private final int CLIENT_ERROR_LOW_CODE = 100;

    public Response toResponse(WebApplicationException ex) {
        String outMessClient;
        Object status;
        Response r = ex.getResponse();
        int responseStatus = r != null ? r.getStatus() : Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        String outMess = ex.getMessage();
        try {
            Message m;
            if (r != null && r.getEntity() != null) {
                outMess = (String)r.readEntity(String.class);
            }
            if (ex instanceof ClientErrorException && r instanceof ResponseImpl && (m = ((ResponseImpl)r).getOutMessage()) != null && m.get((Object)"org.apache.cxf.request.uri") != null) {
                outMess = outMess + System.lineSeparator() + "Request URI: " + m.get((Object)"org.apache.cxf.request.uri");
            }
        }
        catch (Throwable ex_) {
            LOG.log(Level.SEVERE, "error on getting  addinional exception info", ex_);
        }
        if (outMess == null || outMess.isEmpty()) {
            outMess = ex.toString();
        }
        LOG.log(Level.WARNING, outMess, (Throwable)ex);
        if (responseStatus >= Response.Status.INTERNAL_SERVER_ERROR.getStatusCode() || responseStatus < 100) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
            outMessClient = Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase();
        } else if (ex.getCause() != null && ex.getCause() instanceof IllegalArgumentException && responseStatus == Response.Status.NOT_FOUND.getStatusCode()) {
            outMessClient = "Unclassifiable server error";
            status = new CustomResponseStatus(450, outMessClient);
        } else {
            outMessClient = outMess;
            status = new CustomResponseStatus(responseStatus, outMessClient);
        }
        return Response.status((Response.StatusType)status).entity((Object)outMessClient).header("Content-Type", (Object)"text/plain;charset=UTF-8").build();
    }
}

