/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.interceptors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

public class ReplaceInInterceptor
implements ReaderInterceptor {
    String encoding = "UTF-8";
    Map<String, String> replacements;
    MediaType mediaType = new MediaType();

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setReplacements(Map<String, String> replacements) {
        this.replacements = replacements;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = JAXRSUtils.toMediaType((String)mediaType);
    }

    public Object aroundReadFrom(ReaderInterceptorContext \u0441ontext) throws IOException, WebApplicationException {
        if (this.replacements != null && this.mediaType.isCompatible(\u0441ontext.getMediaType())) {
            InputStream inputStream = \u0441ontext.getInputStream();
            byte[] bytes = new byte[inputStream.available()];
            inputStream.read(bytes);
            String contents = new String(bytes);
            for (Map.Entry<String, String> keyValue : this.replacements.entrySet()) {
                contents = contents.replaceAll(keyValue.getKey(), keyValue.getValue());
            }
            \u0441ontext.setInputStream((InputStream)new ByteArrayInputStream(contents.getBytes()));
            return \u0441ontext.proceed();
        }
        return \u0441ontext.proceed();
    }
}

