/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.search;

import java.util.ArrayList;
import java.util.LinkedList;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.cxf.jaxrs.ext.search.jpa.JPATypedQueryVisitor;

public class JPAOrderedQueryVisitor<T>
extends JPATypedQueryVisitor<T> {
    private final EntityManager em;
    private final Class<T> tClass;

    public JPAOrderedQueryVisitor(EntityManager em, Class<T> tClass) {
        super(em, tClass);
        this.em = em;
        this.tClass = tClass;
    }

    public CriteriaQuery<T> getOrderedCriteriaQuery(JPATypedQueryVisitor<T> visitor, String orderList) {
        String[] orderParts = orderList.split(",");
        ArrayList<Order> orders = new ArrayList<Order>();
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        EntityType entity = this.em.getMetamodel().entity(this.tClass);
        for (String orderPart : orderParts) {
            String[] subSort;
            boolean asc = true;
            String[] sort = orderPart.split(" ");
            if (sort.length > 1) {
                boolean bl = asc = !sort[1].equals("desc");
            }
            if ((subSort = sort[0].split("\\.")).length > 1) {
                for (Join join : visitor.getRoot().getJoins()) {
                    if (!join.getAttribute().getName().equals(subSort[0])) continue;
                    Order order = asc ? cb.asc((Expression)join.get(subSort[1])) : cb.desc((Expression)join.get(subSort[1]));
                    orders.add(order);
                }
                continue;
            }
            LinkedList<SingularAttribute> selections = new LinkedList<SingularAttribute>();
            selections.add(entity.getSingularAttribute(sort[0]));
            for (SingularAttribute attribute : selections) {
                Path selection = visitor.getRoot().get(attribute);
                Order order = asc ? cb.asc((Expression)selection) : cb.desc((Expression)selection);
                orders.add(order);
            }
        }
        return visitor.getCriteriaQuery().orderBy(orders);
    }
}

