/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.exceptionhandler;

import java.io.InputStream;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class ExceptionHandler
implements ExceptionMapper<Exception> {
    private static final Logger LOG = Logger.getLogger(ExceptionHandler.class.getName());
    int defaultResponseStatus = 500;
    String contentType = "text/plain; charset=UTF-8";

    public void setDefaultResponseStatus(int defaultResponseStatus) {
        this.defaultResponseStatus = defaultResponseStatus;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Response toResponse(Exception ex) {
        int responseStatus = this.defaultResponseStatus;
        String outMess = ex.getMessage();
        try {
            if (ex instanceof WebApplicationException) {
                Response r = ((WebApplicationException)ex).getResponse();
                if (r != null && r.getEntity() != null && r.getEntity() instanceof InputStream) {
                    outMess = new Scanner((InputStream)r.getEntity(), "UTF-8").useDelimiter("\\A").next();
                }
                responseStatus = ((WebApplicationException)ex).getResponse().getStatus();
            }
            if (ex instanceof BadRequestException && ex.getCause() != null && ex.getCause().getMessage() != null) {
                outMess = ex.getCause().getMessage();
            }
        }
        catch (Throwable ex_) {
            LOG.log(Level.SEVERE, "error on getting  addinional exception info", ex_);
        }
        if (outMess == null) {
            outMess = "";
        }
        LOG.log(Level.SEVERE, outMess, ex);
        return Response.status((int)responseStatus).entity((Object)outMess).type(this.contentType).build();
    }
}

