/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.converters;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.TimeZone;
import javax.ws.rs.ext.ParamConverter;
import javax.xml.bind.DatatypeConverter;

public class LocalDateTimeParamConverter
implements ParamConverter<LocalDateTime> {
    public LocalDateTime fromString(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            Calendar parsedDateTime = DatatypeConverter.parseDateTime((String)value);
            TimeZone tz = parsedDateTime.getTimeZone();
            ZoneId zid = tz == null ? ZoneId.systemDefault() : tz.toZoneId();
            return LocalDateTime.ofInstant(parsedDateTime.toInstant(), zid);
        }
        catch (Exception parsedDateTime) {
            try {
                ZonedDateTime parsedDateTime2 = ZonedDateTime.parse(value, DateTimeFormatter.ISO_ZONED_DATE_TIME);
                ZoneId zid = parsedDateTime2.getZone() == null ? ZoneId.systemDefault() : parsedDateTime2.getZone();
                return LocalDateTime.ofInstant(parsedDateTime2.toInstant(), zid);
            }
            catch (Exception ex) {
                throw new DateTimeParseException("Text '" + value + "' could not be parsed to LocalDateTime.", value, 0, ex);
            }
        }
    }

    public String toString(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.of(value, OffsetDateTime.now().getOffset()));
    }
}

