/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.exceptionhandler;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import ru.ilb.common.jaxb.util.JaxbUtil;
import ru.ilb.common.jaxrs.exceptionhandler.CustomResponseStatus;

@Provider
public class WebApplicationExceptionHandler
implements ExceptionMapper<WebApplicationException> {
    private static final Logger LOG = Logger.getLogger(WebApplicationExceptionHandler.class.getName());
    private static final String KEY_EXCHANGE_ID = "exchangeId";
    private static final String UNCLASSIFIABLE_SERVER_ERROR_TEXT = "Unclassifiable server error";
    private static final int CLIENT_HTTP_ERROR = 450;
    private static final int CASCADE_HTTP_ERROR = 555;
    @Context
    private ContextResolver<JAXBContext> jaxbContextResolver;

    public Response toResponse(WebApplicationException ex) {
        CustomResponseStatus status;
        Response response = ex.getResponse();
        int responseStatus = response != null ? response.getStatus() : Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        Message currentMessage = PhaseInterceptorChain.getCurrentMessage();
        String exchangeId = currentMessage != null && currentMessage.getExchange() != null ? (String)currentMessage.getExchange().get((Object)KEY_EXCHANGE_ID) : "(no current exchange)";
        StringBuilder message = new StringBuilder();
        StringBuilder logstr = new StringBuilder();
        try {
            if (response != null && response.getEntity() != null) {
                Message outMessage = null;
                boolean cascade = false;
                if (response instanceof ResponseImpl && (outMessage = ((ResponseImpl)response).getOutMessage()) != null) {
                    cascade = Boolean.TRUE.equals(outMessage.get((Object)"org.apache.cxf.client"));
                }
                if (cascade) {
                    message.append("Cascade http error ").append(responseStatus);
                    message.append(" from ").append(outMessage.get((Object)"org.apache.cxf.request.uri"));
                    if (response.getEntity() != null) {
                        logstr.append("Cascade response:").append((String)response.readEntity(String.class));
                    }
                    responseStatus = 555;
                    if (this.jaxbContextResolver != null && outMessage.get((Object)"java.util.List") != null) {
                        List list = (List)outMessage.get((Object)"java.util.List");
                        String contentType = (String)outMessage.get((Object)"Content-Type");
                        if ("application/xml".equals(contentType) || "application/json".equals(contentType)) {
                            for (Object object : list) {
                                logstr.append("\nObject: ").append(JaxbUtil.marshal((JAXBContext)((JAXBContext)this.jaxbContextResolver.getContext(object.getClass())), object, (String)contentType));
                            }
                        }
                    }
                } else {
                    message.append((String)response.readEntity(String.class));
                }
            } else {
                message.append(ex.getMessage());
            }
        }
        catch (Throwable ex_) {
            LOG.log(Level.SEVERE, "error on getting  addinional exception info", ex_);
        }
        if (message.length() == 0) {
            message.append(UNCLASSIFIABLE_SERVER_ERROR_TEXT);
            logstr.append(ex.toString());
        }
        if (exchangeId != null) {
            message.append("\nExchange Id: ").append(exchangeId);
        }
        if (logstr.length() != 0) {
            logstr.append('\n');
        }
        logstr.append((CharSequence)message);
        LOG.log(Level.WARNING, logstr.toString(), (Throwable)ex);
        String outMess = message.toString();
        if (ex.getCause() != null && ex.getCause() instanceof IllegalArgumentException && responseStatus == Response.Status.NOT_FOUND.getStatusCode()) {
            outMess = UNCLASSIFIABLE_SERVER_ERROR_TEXT;
            status = new CustomResponseStatus(450, outMess);
        } else {
            status = new CustomResponseStatus(responseStatus, outMess);
        }
        return Response.status((Response.StatusType)status).entity((Object)outMess).header("Content-Type", (Object)"text/plain;charset=UTF-8").build();
    }
}

