/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.exceptionhandler;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import ru.ilb.common.jaxrs.exceptionhandler.ExceptionHandler;

public class SendMailExceptionHandler
extends ExceptionHandler {
    private static final Logger LOG = Logger.getLogger(SendMailExceptionHandler.class.getName());
    String mailTo = "root";
    String mailSubject = "[JAVA FATAL ERROR]";
    String mailCommand = "/usr/sbin/sendmail -t -oi";
    int mailResponseStatus = 500;

    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }

    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public void setMailCommand(String mailCommand) {
        this.mailCommand = mailCommand;
    }

    public void setMailResponseStatus(int mailResponseStatus) {
        this.mailResponseStatus = mailResponseStatus;
    }

    @Override
    public Response toResponse(Exception ex) {
        Response res = super.toResponse(ex);
        if (res.getStatus() >= this.mailResponseStatus) {
            String mailMsg = this.getMailMsg(ex, res.getStatus(), (String)res.getEntity());
            this.sendMail(mailMsg);
        }
        return res;
    }

    private String getMailMsg(Exception ex, int code, String outMess) {
        String mailMsg = "";
        try {
            String threadid = Thread.currentThread().getName();
            String uuid = UUID.randomUUID().toString();
            String cause = ex.getCause() == null ? ex.getClass().getName() : ex.getCause().getClass().getName();
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            String trace = writer.toString();
            int line2 = trace.indexOf("\n");
            mailMsg = "To: " + this.mailTo + "\n" + "Subject: " + this.mailSubject + " " + threadid + "\n" + "Content-Type: " + this.contentType + "\n\n" + cause + ": " + outMess + "\n" + code + " " + threadid + " " + uuid + "\n" + (line2 < 0 ? trace : trace.substring(line2 + 1));
        }
        catch (Throwable ex_) {
            LOG.log(Level.SEVERE, "error constructing mailMsg", ex_);
        }
        return mailMsg;
    }

    private void sendMail(String mailMsg) {
        try {
            Process p = Runtime.getRuntime().exec(this.mailCommand);
            OutputStream o = p.getOutputStream();
            o.write(mailMsg.getBytes("UTF-8"));
            o.flush();
            o.close();
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new Exception("sendmail exitValue=" + p.exitValue());
            }
        }
        catch (Throwable ex_) {
            LOG.log(Level.SEVERE, "sendmail failed", ex_);
        }
    }
}

