/*
 * Copyright 2016 Bystrobank
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ru.ilb.common.jaxrs.exceptionhandler;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

/**
 *
 * @author slavb
 */
@Provider
public class BadRequestExceptionHandler extends AbstractExceptionHandler<BadRequestException> {

    /**
     * default http response status
     */
    int defaultResponseStatus = 400;

    private static final Logger LOG = Logger.getLogger(BadRequestExceptionHandler.class.getName());

    @Override
    public Response toResponse(BadRequestException ex) {
        int responseStatus = defaultResponseStatus;
        String outMess = ex.getMessage();
        if (ex.getCause() != null && ex.getCause().getMessage() != null) {
            outMess = ex.getCause().getMessage();
        }
        LOG.log(Level.WARNING, outMess, ex);

        return Response.status(responseStatus).entity(outMess).type(contentType).build();

    }

}
