/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jaxrs.async;

import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import ru.ilb.common.jaxrs.async.AsyncTask;

public class AsyncTaskManager {
    private final Map<String, AsyncTask> tasks = new ConcurrentHashMap<String, AsyncTask>();
    private final ExecutorService taskExecutor = Executors.newCachedThreadPool();

    public void destroy() {
        for (Map.Entry<String, AsyncTask> entry : this.tasks.entrySet()) {
            if (entry.getValue().getFuture().isDone()) continue;
            entry.getValue().getFuture().cancel(true);
        }
    }

    public AsyncTask submit(Callable clbl) {
        String taskId = UUID.randomUUID().toString();
        Future future = this.taskExecutor.submit(clbl);
        AsyncTask task = new AsyncTask(taskId, future);
        this.tasks.put(taskId, task);
        return task;
    }

    public AsyncTask get(String taskId) {
        return this.tasks.get(taskId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response execute(Callable clbl, UriInfo uriInfo) {
        Response response;
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        String mode = (String)queryParams.getFirst((Object)"mode");
        String seeOther = (String)queryParams.getFirst((Object)"seeOther");
        String taskId = (String)queryParams.getFirst((Object)"taskId");
        if ("wait".equals(mode)) {
            String i = (String)queryParams.getFirst((Object)"i");
            AsyncTask task = this.get(taskId);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.GONE).type("text/plain; charset=UTF-8").entity((Object)("\u0417\u0430\u0434\u0430\u0447\u0430 " + taskId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")).build();
            }
            if (!task.getFuture().isDone()) {
                UriBuilder uri = uriInfo.getAbsolutePathBuilder().queryParam("mode", new Object[]{"wait"}).queryParam("taskId", new Object[]{taskId}).queryParam("i", new Object[]{Integer.parseInt(i) + 1});
                if (seeOther == null) return Response.status((Response.Status)Response.Status.ACCEPTED).type("text/plain; charset=UTF-8").entity((Object)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f.. ").header("Refresh", (Object)("2;" + uri.build(new Object[0]).toString())).build();
                uri.queryParam("seeOther", new Object[]{seeOther});
                int timeout = 2;
                if (seeOther.length() > 0) {
                    timeout = Integer.parseInt(seeOther);
                }
                try {
                    TimeUnit.SECONDS.sleep(timeout);
                    return Response.seeOther((URI)uri.build(new Object[0])).build();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            try {
                response = task.getFuture().get() instanceof Response ? (Response)task.getFuture().get() : Response.status((Response.Status)Response.Status.OK).entity(task.getFuture().get()).type("application/xml").build();
                this.remove(taskId);
                return response;
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            catch (ExecutionException ex) {
                if (ex.getCause() == null) throw new RuntimeException(ex);
                if (!(ex.getCause() instanceof RuntimeException)) throw new RuntimeException(ex.getCause());
                throw (RuntimeException)ex.getCause();
            }
        }
        if ("cancel".equals(mode)) {
            AsyncTask task = this.get(taskId);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.GONE).type("text/plain; charset=UTF-8").entity((Object)("\u0417\u0430\u0434\u0430\u0447\u0430 " + taskId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")).build();
            }
            if (task.getFuture().isDone()) return Response.status((Response.Status)Response.Status.OK).type("text/plain; charset=UTF-8").entity((Object)("\u0417\u0430\u0434\u0430\u0447\u0430 " + taskId + " \u0443\u0436\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430")).build();
            task.getFuture().cancel(true);
            response = Response.status((Response.Status)Response.Status.OK).type("text/plain; charset=UTF-8").entity((Object)("\u0417\u0430\u0434\u0430\u0447\u0430 " + taskId + " \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430")).build();
            this.remove(taskId);
            return response;
        } else {
            AsyncTask task = this.submit(clbl);
            UriBuilder uri = uriInfo.getAbsolutePathBuilder().queryParam("mode", new Object[]{"wait"}).queryParam("taskId", new Object[]{task.getTaskId()}).queryParam("i", new Object[]{0});
            if (seeOther == null) return Response.seeOther((URI)uri.build(new Object[0])).build();
            uri.queryParam("seeOther", new Object[]{seeOther});
            return Response.seeOther((URI)uri.build(new Object[0])).build();
        }
    }

    public AsyncTask remove(String taskId) {
        return this.tasks.remove(taskId);
    }
}

