
package ru.ilb.common.jpa;

import java.util.UUID;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

/**
 *
 * @author rusanov
 */
@Converter
public class UUIDConverterString implements AttributeConverter<UUID, String> {

    @Override
    public String convertToDatabaseColumn(UUID uuid) {
        if(uuid == null){
            return null;
        }
        return uuid.toString().toUpperCase();
    }

    @Override
    public UUID convertToEntityAttribute(String uuid) {
        if(uuid == null || uuid.length() == 0){
            return null;
        }
        return UUID.fromString(uuid);
    }

}
