/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.converters;

import java.nio.ByteBuffer;
import java.util.UUID;

public abstract class UUIDConverter {
    public static byte[] uuidToBytes(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static UUID bytesToUUID(byte[] bytes) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (bytes.length != 16) {
            throw new IllegalArgumentException("data should be 16 bytes length");
        }
        long msl = 0L;
        for (i = 0; i < 8; ++i) {
            msl = msl << 8 | (long)(bytes[i] & 0xFF);
        }
        long lsl = 0L;
        while (i < 16) {
            lsl = lsl << 8 | (long)(bytes[i] & 0xFF);
            ++i;
        }
        return new UUID(msl, lsl);
    }
}

