/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.bitset;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ru.ilb.common.jpa.bitset.BitAccessor;

public class BitSet<T>
implements Serializable {
    protected Long value;
    private final BitAccessor accessor = new BitAccessor(this.getParamClass(0));

    public BitSet() {
    }

    public BitSet(Long value) {
        this.value = value;
    }

    public BitSet(Set<T> items) {
        this.addAll(items);
    }

    private Class<T> getParamClass(int pos) {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[pos];
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public boolean contains(T item) {
        return this.isSetBit(this.accessor.getBitNum(item));
    }

    public void add(T item) {
        this.setBit(this.accessor.getBitNum(item));
    }

    public void addAll(Set<T> items) {
        items.forEach(item -> this.setBit(this.accessor.getBitNum(item)));
    }

    public Long setBit(long pos) {
        if (this.value == null) {
            this.value = 0L;
        }
        this.value = this.value | 1L << (int)pos;
        return this.value;
    }

    private boolean isSetBit(long pos) {
        return this.value != null && (this.value >> (int)pos & 1L) != 0L;
    }

    public List<Long> getSetBits() {
        ArrayList<Long> res = new ArrayList<Long>();
        for (long pos = 0L; pos < 64L; ++pos) {
            if (!this.isSetBit(pos)) continue;
            res.add(pos);
        }
        return res;
    }
}

