/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.bitset;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ru.ilb.common.jpa.bitset.BitAccessor;
import ru.ilb.common.jpa.bitset.EntityBitAccessor;
import ru.ilb.common.jpa.bitset.EnumBitAccessor;

public class BitSet<T>
implements Serializable {
    protected Long value;
    private final BitAccessor accessor;

    public BitSet() {
        Class<T> clazz = this.getParamClass(0);
        this.accessor = clazz.isEnum() ? new EnumBitAccessor() : new EntityBitAccessor(clazz);
    }

    public BitSet(Long value) {
        this();
        this.value = value;
    }

    public BitSet(Collection<T> items) {
        this();
        this.addAll(items);
    }

    private Class<T> getParamClass(int pos) {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[pos];
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public boolean contains(T item) {
        return this.isSetBit(this.accessor.getBitNum(item));
    }

    public void add(T item) {
        this.setBit(this.accessor.getBitNum(item));
    }

    public final void addAll(Collection<T> items) {
        items.forEach(item -> this.setBit(this.accessor.getBitNum(item)));
    }

    public Long setBit(long pos) {
        if (this.value == null) {
            this.value = 0L;
        }
        this.value = this.value | 1L << (int)pos;
        return this.value;
    }

    private boolean isSetBit(long pos) {
        return this.value != null && (this.value >> (int)pos & 1L) != 0L;
    }

    public List<Long> getSetBits() {
        ArrayList<Long> res = new ArrayList<Long>();
        for (long pos = 0L; pos < 64L; ++pos) {
            if (!this.isSetBit(pos)) continue;
            res.add(pos);
        }
        return res;
    }
}

