/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.history;

import java.lang.reflect.AnnotatedElement;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicTypeBuilder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.schemaframework.DefaultTableGenerator;
import org.eclipse.persistence.tools.schemaframework.DynamicSchemaManager;
import org.eclipse.persistence.tools.schemaframework.IndexDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.transaction.annotation.Transactional;
import ru.ilb.common.jpa.history.AutoHistory;

public class AutoHistoryEntityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHistoryEntityUtil.class);
    private static final String SEQ_GEN_HIST_IDENTITY = "SEQ_GEN_HIST_IDENTITY";
    Session session;

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.session = JpaHelper.getServerSession((EntityManagerFactory)entityManagerFactory);
    }

    @PostConstruct
    @Transactional
    void initialize() {
        List<ClassDescriptor> descriptors = this.session.getDescriptors().values().stream().filter(d -> AnnotationUtils.getAnnotation((AnnotatedElement)d.getJavaClass(), AutoHistory.class) != null).collect(Collectors.toList());
        this.createHistoryEntities((DatabaseSession)this.session, descriptors);
    }

    void createHistoryEntities(DatabaseSession session, Collection<ClassDescriptor> descriptors) {
        DynamicClassLoader dcl = new DynamicClassLoader(DatabaseSession.class.getClassLoader());
        List<DynamicType> types = descriptors.stream().map(descriptor -> this.createHistoryType((ClassDescriptor)descriptor, dcl)).collect(Collectors.toList());
        boolean createMissingTables = false;
        boolean generateFKConstraints = false;
        NativeSequence sequence = new NativeSequence(SEQ_GEN_HIST_IDENTITY, true);
        session.getDatasourcePlatform().addSequence((Sequence)sequence);
        this.addTypes(session, createMissingTables, generateFKConstraints, types.toArray(new DynamicType[types.size()]));
        this.createTables(session, generateFKConstraints);
    }

    private void addTypes(DatabaseSession session, boolean createMissingTables, boolean generateFKConstraints, DynamicType ... types) {
        DynamicHelper helper = new DynamicHelper(session);
        helper.addTypes(createMissingTables, generateFKConstraints, types);
        for (DynamicType type : types) {
            type.getDescriptor().getQueryManager().checkDatabaseForDoesExist();
        }
    }

    private void createTables(DatabaseSession session, boolean generateFKConstraints) {
        if (!session.isConnected()) {
            session.login();
        }
        DynamicSchemaManager dsm = new DynamicSchemaManager(session);
        TableCreator creator = new DefaultTableGenerator(session.getProject(), generateFKConstraints).generateFilteredDefaultTableCreator((AbstractSession)session);
        creator.setIgnoreDatabaseException(true);
        creator.extendTables(session, (SchemaManager)dsm);
    }

    private DynamicType createHistoryType(ClassDescriptor descriptor, DynamicClassLoader dcl) {
        Class employeeClass = dcl.createDynamicClass(descriptor.getJavaClassName() + "Hist");
        String tableName = descriptor.getTableName() + "HIST";
        JPADynamicTypeBuilder builder = new JPADynamicTypeBuilder(employeeClass, null, new String[]{tableName});
        builder.setPrimaryKeyFields(new String[]{"HISTID"});
        builder.addDirectMapping("histId", Long.class, "HISTID");
        IndexDefinition idxId = new IndexDefinition();
        idxId.setTargetTable(tableName);
        idxId.setName("INDEX_" + tableName + "_ID");
        idxId.addField("ID");
        ((DatabaseTable)builder.getType().getDescriptor().getTables().get(0)).getIndexes().add(idxId);
        builder.configureSequencing(SEQ_GEN_HIST_IDENTITY, "HISTID");
        builder.addDirectMapping("rowStart", Timestamp.class, "ROWSTART");
        builder.addDirectMapping("rowEnd", Timestamp.class, "ROWEND");
        IndexDefinition idxRowStart = new IndexDefinition();
        idxRowStart.setTargetTable(tableName);
        idxRowStart.setName("INDEX_" + tableName + "_ROWSTART");
        idxRowStart.addField("ROWSTART");
        ((DatabaseTable)builder.getType().getDescriptor().getTables().get(0)).getIndexes().add(idxRowStart);
        IndexDefinition idxRowEnd = new IndexDefinition();
        idxRowEnd.setTargetTable(tableName);
        idxRowEnd.setName("INDEX_" + tableName + "_ROWEND");
        idxRowEnd.addField("ROWEND");
        ((DatabaseTable)builder.getType().getDescriptor().getTables().get(0)).getIndexes().add(idxRowEnd);
        Vector fields = descriptor.getFields();
        HashSet fieldNames = new HashSet();
        fields.stream().forEach(f -> fieldNames.add(f.getName()));
        List<DatabaseMapping> mappings = descriptor.getMappings().stream().map(m -> this.convertMapping((DatabaseMapping)m)).filter(Objects::nonNull).collect(Collectors.toList());
        mappings.forEach(m -> {
            if (DirectToFieldMapping.class.equals(m.getClass())) {
                LOG.debug("Table " + tableName + " adding DirectToFieldMapping " + m.getAttributeName());
                builder.addMapping(m);
                fieldNames.remove(m.getField().getName());
            } else {
                if (OneToOneMapping.class.equals(m.getClass())) {
                    OneToOneMapping oom = (OneToOneMapping)m;
                    oom.getSourceToTargetKeyFields().entrySet().stream().filter(entr -> fieldNames.contains(((DatabaseField)entr.getKey()).getName())).forEach(entr -> fieldNames.remove(((DatabaseField)entr.getKey()).getName()));
                }
                LOG.debug("Table " + tableName + " adding OneToOneMapping " + m.getAttributeName());
                builder.addMapping(m);
            }
        });
        if (!fieldNames.isEmpty()) {
            fields.stream().filter(df -> fieldNames.contains(df.getName())).forEachOrdered(df -> builder.addDirectMapping(df.getName().toLowerCase(), df.getType(), df.getName()));
        }
        return builder.getType();
    }

    private DatabaseMapping convertMapping(DatabaseMapping src) {
        if (src instanceof DirectToFieldMapping) {
            return this.convertMapping((DirectToFieldMapping)src);
        }
        if (src instanceof OneToOneMapping) {
            return this.convertMapping((OneToOneMapping)src);
        }
        return null;
    }

    private DatabaseMapping convertMapping(DirectToFieldMapping src) {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        if (LocalDate.class.equals((Object)src.getAttributeClassification())) {
            mapping.setAttributeClassification(Date.class);
        } else if (LocalDateTime.class.equals((Object)src.getAttributeClassification())) {
            mapping.setAttributeClassification(Timestamp.class);
        } else if (UUID.class.equals((Object)src.getAttributeClassification())) {
            mapping.setAttributeClassification(Blob.class);
        } else {
            mapping.setAttributeClassification(src.getAttributeClassification());
        }
        mapping.setAttributeName(src.getAttributeName());
        mapping.setFieldName(src.getField().getName());
        return mapping;
    }

    private DatabaseMapping convertMapping(OneToOneMapping src) {
        OneToOneMapping mapping = new OneToOneMapping();
        mapping.setAttributeName(src.getAttributeName());
        mapping.setReferenceClass(src.getReferenceClass());
        src.getSourceToTargetKeyFields().entrySet().stream().forEach(e -> mapping.addForeignKeyFieldName(((DatabaseField)e.getKey()).getName(), ((DatabaseField)e.getValue()).getName()));
        return mapping;
    }
}

