/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.tools;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Component;
import ru.ilb.common.jpa.annotations.AutoPopulableRepository;
import ru.ilb.common.jpa.repository.CacheableJpaRepository;

@Component
public class RepositoryPopulator {
    @Autowired
    ApplicationContext applicationContext;

    @PostConstruct
    public void populateAll() {
        this.applicationContext.getBeansWithAnnotation(AutoPopulableRepository.class).values().stream().forEach(repository -> this.populateRepository((JpaRepository)repository));
    }

    public static <T> List<T> getEntities(Class repositoryInterface, Class<T> clazz) {
        return RepositoryPopulator.getEntities(repositoryInterface);
    }

    public static List getEntities(Class repositoryInterface) {
        ParameterizedType baseInterface = (ParameterizedType)repositoryInterface.getGenericInterfaces()[0];
        Type objectType = baseInterface.getActualTypeArguments()[0];
        List objects = Arrays.stream(repositoryInterface.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getGenericType().equals(objectType)).map(field -> RepositoryPopulator.getFieldValue(field)).collect(Collectors.toList());
        return objects;
    }

    public void populateRepository(JpaRepository repository) {
        List entities = RepositoryPopulator.getEntities((Class)repository.getClass().getGenericInterfaces()[0]);
        entities = repository.save((Iterable)entities);
        if (repository instanceof CacheableJpaRepository) {
            ((CacheableJpaRepository)repository).fillCache(entities);
        }
    }

    private static Object getFieldValue(Field field) {
        try {
            return field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            return null;
        }
    }
}

