/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.bitset;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.persistence.Id;
import ru.ilb.common.jpa.bitset.BitAccessor;

public class EntityBitAccessor
implements BitAccessor {
    protected final Field idField;

    public EntityBitAccessor(Class clazz) {
        this.idField = this.findField(clazz, Id.class);
    }

    @Override
    public int getBitNum(Object o) {
        return this.getId(o) - 1;
    }

    private Integer getId(Object o) {
        try {
            Object obj = this.idField.get(o);
            if (obj instanceof Long) {
                return ((Long)obj).intValue();
            }
            if (obj instanceof Integer) {
                return (int)((Integer)obj);
            }
            if (obj instanceof Byte) {
                return ((Byte)obj).intValue();
            }
            if (obj instanceof Short) {
                return ((Short)obj).intValue();
            }
            return Integer.parseInt(String.valueOf(obj));
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private Field findField(Class<?> classs, Class<? extends Annotation> ann) {
        for (Class<?> c = classs; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ann)) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return null;
    }
}

