/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.jaxb;

import com.sun.xml.internal.bind.api.AccessorException;
import com.sun.xml.internal.bind.v2.runtime.reflect.Accessor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.indirection.IndirectContainer;

public class LazyCustomFieldAccessor<BeanT, ValueT>
extends Accessor<BeanT, ValueT> {
    private Field field;
    private static final Map<Class, Object> uninitializedValues = new HashMap<Class, Object>();

    public LazyCustomFieldAccessor(Class<ValueT> valueType) {
        super(valueType);
    }

    public LazyCustomFieldAccessor(Class<ValueT> type, Field field) {
        super(type);
        this.field = field;
    }

    public ValueT get(BeanT bean) throws AccessorException {
        try {
            IndirectContainer container = (IndirectContainer)this.field.get(bean);
            if (container != null && container.isInstantiated()) {
                return (ValueT)this.field.get(bean);
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public void set(BeanT bean, ValueT value) throws AccessorException {
        try {
            if (value == null) {
                value = uninitializedValues.get(this.valueType);
            }
            this.field.set(bean, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    static {
        uninitializedValues.put(Byte.TYPE, (byte)0);
        uninitializedValues.put(Boolean.TYPE, false);
        uninitializedValues.put(Character.TYPE, Character.valueOf('\u0000'));
        uninitializedValues.put(Float.TYPE, Float.valueOf(0.0f));
        uninitializedValues.put(Double.TYPE, 0.0);
        uninitializedValues.put(Integer.TYPE, 0);
        uninitializedValues.put(Long.TYPE, 0L);
        uninitializedValues.put(Short.TYPE, (short)0);
    }
}

