/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.tools;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import ru.ilb.common.jpa.annotations.AutoPopulableRepository;
import ru.ilb.common.jpa.repository.CacheableJpaRepository;
import ru.ilb.common.jpa.tools.DescriptorUtils;

@Component
public class RepositoryPopulator {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private DescriptorUtils descriptorUtils;
    @Autowired
    @Qualifier(value="transactionManager")
    private PlatformTransactionManager platformTransactionManager;

    @PostConstruct
    public void populateAll() {
        this.applicationContext.getBeansWithAnnotation(AutoPopulableRepository.class).values().stream().forEach(repository -> this.populateRepositoryInTransaction((JpaRepository)repository));
    }

    public static <T> List<T> getEntities(Class repositoryInterface, Class<T> clazz) {
        return RepositoryPopulator.getEntities(repositoryInterface);
    }

    public static List getEntities(Class repositoryInterface) {
        ParameterizedType baseInterface = (ParameterizedType)repositoryInterface.getGenericInterfaces()[0];
        Type objectType = baseInterface.getActualTypeArguments()[0];
        List objects = Arrays.stream(repositoryInterface.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getGenericType().equals(objectType)).map(field -> RepositoryPopulator.getFieldValue(field)).collect(Collectors.toList());
        return objects;
    }

    public void populateRepositoryInTransaction(final JpaRepository repository) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.platformTransactionManager);
        transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus ts) {
                RepositoryPopulator.this.populateRepository(repository);
            }
        });
    }

    public void populateRepository(JpaRepository repository) {
        AutoPopulableRepository annotation = (AutoPopulableRepository)AnnotationUtils.findAnnotation(repository.getClass(), AutoPopulableRepository.class);
        List entities = RepositoryPopulator.getEntities((Class)repository.getClass().getGenericInterfaces()[0]);
        entities = this.populateRepositoryMerge(repository, annotation, entities);
        if (repository instanceof CacheableJpaRepository) {
            ((CacheableJpaRepository)repository).fillCache(entities);
        }
    }

    private List populateRepositoryMerge(JpaRepository repository, AutoPopulableRepository annotation, List entities) {
        if (this.descriptorUtils == null) {
            throw new IllegalArgumentException("DescriptorUtils bean required for FINDALL mode");
        }
        List base = repository.findAll();
        ArrayList<Object> result = new ArrayList<Object>();
        Map<Object, Object> dstMap = this.descriptorUtils.mapById(base);
        for (Object src : entities) {
            Object pk = this.descriptorUtils.getPrimaryKeyValue(src);
            if (dstMap.containsKey(pk)) {
                Object dst = dstMap.get(pk);
                this.descriptorUtils.copyProperties(src, dst, annotation.mergeMappingTypes());
                result.add(dst);
                continue;
            }
            result.add(repository.save(src));
        }
        return result;
    }

    private static Object getFieldValue(Field field) {
        try {
            return field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            return null;
        }
    }
}

