/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.configurations;

import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class PersistancePropertiesFactoryBean
implements FactoryBean<Map> {
    private static final Logger logger = LoggerFactory.getLogger(PersistancePropertiesFactoryBean.class);
    private String model;
    private String data;
    private DataSource dataSource;
    private Map<String, byte[]> checksumMap;
    private Map<String, Object> propertyMap;

    public void setModel(String model) {
        this.model = model;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private byte[] getCheckSum(String file) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(file);
                 DigestInputStream dis = new DigestInputStream(is, md);){
                byte[] buffer = new byte[1024];
                while (dis.read(buffer) != -1) {
                }
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return md.digest();
    }

    private Map fillChecksumMapFromDB() {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        String createDBQuery = "CREATE TABLE IF NOT EXISTS CHECKSUM (FILE VARCHAR(50) NOT NULL, CHECKSUM BINARY(16) )";
        String selectCheckSum = "SELECT * FROM CHECKSUM";
        try (Connection conn = this.dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(createDBQuery);
            ResultSet rs = stmt.executeQuery(selectCheckSum);
            while (rs.next()) {
                String file = rs.getString("FILE");
                byte[] checkSum = rs.getBytes("CHECKSUM");
                result.put(file, checkSum);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    private void updateCheckSumInDB(String file, byte[] checkSum) {
        String updateQuery = "UPDATE CHECKSUM SET CHECKSUM = ? WHERE FILE = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(updateQuery);){
            stmt.setBytes(1, checkSum);
            stmt.setString(2, file);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void insertCheckSumInDB(String file, byte[] checkSum) {
        String insertQuery = "INSERT INTO CHECKSUM\n(FILE, CHECKSUM) value (?, ?)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(insertQuery);){
            stmt.setString(1, file);
            stmt.setBytes(2, checkSum);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setProperty(String file) {
        if (this.model != null && this.model.equals(file)) {
            this.propertyMap.put("javax.persistence.schema-generation.database.action", "create-or-extend-tables");
        } else if (this.data != null && this.data.equals(file)) {
            this.propertyMap.put("javax.persistence.sql-load-script-source", file);
        }
    }

    public Map getObject() throws Exception {
        logger.info(">>>START set persistence properties");
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap<String, Object>();
        }
        Map checkSumFromDB = this.fillChecksumMapFromDB();
        HashMap<String, byte[]> currentCheckSums = new HashMap<String, byte[]>();
        if (this.model != null) {
            currentCheckSums.put(this.model, this.getCheckSum(this.model));
        }
        if (this.data != null) {
            currentCheckSums.put(this.data, this.getCheckSum(this.data));
        }
        for (Map.Entry pair : currentCheckSums.entrySet()) {
            if (checkSumFromDB.containsKey(pair.getKey())) {
                byte[] oldCheckSum = (byte[])checkSumFromDB.get(pair.getKey());
                if (!Arrays.equals((byte[])pair.getValue(), oldCheckSum)) {
                    this.setProperty((String)pair.getKey());
                    this.updateCheckSumInDB((String)pair.getKey(), (byte[])pair.getValue());
                    logger.info(">>> \u0423 \u0444\u0430\u0439\u043b\u0430 {} checkSum \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0430\u0441\u044c, \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0435 property", pair.getKey());
                    continue;
                }
                logger.info(">>> \u0423 \u0444\u0430\u0439\u043b\u0430 {} checkSum \u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0430\u0441\u044c", pair.getKey());
                continue;
            }
            this.setProperty((String)pair.getKey());
            this.insertCheckSumInDB((String)pair.getKey(), (byte[])pair.getValue());
        }
        logger.info(">>>END set persistence properties");
        return this.propertyMap;
    }

    public Class<? extends Map> getObjectType() {
        return this.checksumMap != null ? this.checksumMap.getClass() : Map.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

