/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.history;

import java.lang.reflect.AnnotatedElement;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.sessions.Session;
import org.springframework.core.annotation.AnnotationUtils;
import ru.ilb.common.jpa.history.AutoHistory;

public class HistorySessionCustomizer
implements SessionCustomizer {
    public void customize(Session session) throws Exception {
        List descriptors = session.getDescriptors().values().stream().filter(d -> AnnotationUtils.getAnnotation((AnnotatedElement)d.getJavaClass(), AutoHistory.class) != null).collect(Collectors.toList());
        descriptors.stream().forEach(d -> this.customize(session, (ClassDescriptor)d));
    }

    private void customize(Session session, ClassDescriptor descriptor) {
        HistoryPolicy policy = new HistoryPolicy();
        String primaryTable = descriptor.getTableName();
        if (primaryTable == null) {
            Class parentClass = descriptor.getInheritancePolicy().getParentClass();
            ClassDescriptor parentDescriptor = session.getClassDescriptor(parentClass);
            primaryTable = parentDescriptor.getTableName();
        }
        policy.addStartFieldName(primaryTable + ".ROWSTART");
        policy.addEndFieldName(primaryTable + ".ROWEND");
        policy.addHistoryTableName(primaryTable, primaryTable + "HIST");
        descriptor.setHistoryPolicy(policy);
    }
}

