/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.bitset;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import ru.ilb.common.jpa.bitset.BitAccessor;
import ru.ilb.common.jpa.bitset.EntityBitAccessor;
import ru.ilb.common.jpa.bitset.EnumBitAccessor;

public class BitSet<T>
implements Serializable {
    protected Long value;
    private final BitAccessor accessor;

    public BitSet() {
        Class<T> clazz = this.getParamClass(0);
        this.accessor = clazz.isEnum() ? new EnumBitAccessor() : new EntityBitAccessor(clazz);
    }

    public BitSet(Long value) {
        this();
        this.value = value;
    }

    public BitSet(Collection<T> items) {
        this();
        this.addAll(items);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitSet other = (BitSet)obj;
        return Objects.equals(this.value, other.value);
    }

    private Class<T> getParamClass(int pos) {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[pos];
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public boolean contains(T item) {
        return this.isSetBit(this.accessor.getBitNum(item));
    }

    public void add(T item) {
        this.setBit(this.accessor.getBitNum(item));
    }

    public final void addAll(Collection<T> items) {
        items.forEach(item -> this.setBit(this.accessor.getBitNum(item)));
    }

    private Long setBit(int pos) {
        if (this.value == null) {
            this.value = 0L;
        }
        this.value = this.value | 1L << pos;
        return this.value;
    }

    private boolean isSetBit(int pos) {
        return this.value != null && (this.value >> pos & 1L) != 0L;
    }

    public List<Integer> getSetBits() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int pos = 0; pos < 64; ++pos) {
            if (!this.isSetBit(pos)) continue;
            res.add(pos);
        }
        return res;
    }
}

