/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.logging;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class Slf4jSessionLogger
extends AbstractSessionLog {
    public static final String ECLIPSELINK_NAMESPACE = "org.eclipse.persistence.logging";
    public static final String DEFAULT_CATEGORY = "default";
    public static final String DEFAULT_ECLIPSELINK_NAMESPACE = "org.eclipse.persistence.logging.default";
    private Map<Integer, LogLevel> mapLevels;
    private Map<String, Logger> categoryLoggers = new HashMap<String, Logger>();

    public Slf4jSessionLogger() {
        this.createCategoryLoggers();
        this.initMapLevels();
    }

    public void log(SessionLogEntry entry) {
        if (!this.shouldLog(entry.getLevel(), entry.getNameSpace())) {
            return;
        }
        Logger logger = this.getLogger(entry.getNameSpace());
        LogLevel logLevel = this.getLogLevel(entry.getLevel());
        StringBuilder message = new StringBuilder();
        message.append(this.getSupplementDetailString(entry));
        message.append(this.formatMessage(entry));
        switch (logLevel) {
            case TRACE: {
                logger.trace(message.toString());
                break;
            }
            case DEBUG: {
                logger.debug(message.toString());
                break;
            }
            case INFO: {
                logger.info(message.toString());
                break;
            }
            case WARN: {
                logger.warn(message.toString());
                break;
            }
            case ERROR: {
                logger.error(message.toString());
            }
        }
    }

    public boolean shouldLog(int level, String category) {
        Logger logger = this.getLogger(category);
        boolean resp = false;
        LogLevel logLevel = this.getLogLevel(level);
        switch (logLevel) {
            case TRACE: {
                resp = logger.isTraceEnabled();
                break;
            }
            case DEBUG: {
                resp = logger.isDebugEnabled();
                break;
            }
            case INFO: {
                resp = logger.isInfoEnabled();
                break;
            }
            case WARN: {
                resp = logger.isWarnEnabled();
                break;
            }
            case ERROR: {
                resp = logger.isErrorEnabled();
            }
        }
        return resp;
    }

    public boolean shouldLog(int level) {
        return this.shouldLog(level, DEFAULT_CATEGORY);
    }

    public boolean shouldDisplayData() {
        if (this.shouldDisplayData != null) {
            return this.shouldDisplayData;
        }
        return false;
    }

    private void createCategoryLoggers() {
        for (String category : SessionLog.loggerCatagories) {
            this.addLogger(category, "org.eclipse.persistence.logging." + category);
        }
        this.addLogger(DEFAULT_CATEGORY, DEFAULT_ECLIPSELINK_NAMESPACE);
    }

    private void addLogger(String loggerCategory, String loggerNameSpace) {
        this.categoryLoggers.put(loggerCategory, LoggerFactory.getLogger((String)loggerNameSpace));
    }

    private Logger getLogger(String category) {
        if (!StringUtils.hasText((String)category) || !this.categoryLoggers.containsKey(category)) {
            category = DEFAULT_CATEGORY;
        }
        return this.categoryLoggers.get(category);
    }

    private LogLevel getLogLevel(Integer level) {
        LogLevel logLevel = this.mapLevels.get(level);
        if (logLevel == null) {
            logLevel = LogLevel.OFF;
        }
        return logLevel;
    }

    private void initMapLevels() {
        this.mapLevels = new HashMap<Integer, LogLevel>();
        this.mapLevels.put(0, LogLevel.TRACE);
        this.mapLevels.put(1, LogLevel.TRACE);
        this.mapLevels.put(2, LogLevel.TRACE);
        this.mapLevels.put(3, LogLevel.DEBUG);
        this.mapLevels.put(4, LogLevel.INFO);
        this.mapLevels.put(5, LogLevel.INFO);
        this.mapLevels.put(6, LogLevel.WARN);
        this.mapLevels.put(7, LogLevel.ERROR);
    }

    static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF;

    }
}

