/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.bitset;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.ilb.common.jpa.bitset.BitAccessor;
import ru.ilb.common.jpa.bitset.EntityBitAccessor;
import ru.ilb.common.jpa.bitset.EnumBitAccessor;

public class BigBitSet<T>
implements Serializable {
    protected BitSet bitSet;
    private final BitAccessor accessor;

    public BigBitSet() {
        Class<T> clazz = this.getParamClass(0);
        this.accessor = clazz.isEnum() ? new EnumBitAccessor() : new EntityBitAccessor(clazz);
    }

    public BigBitSet(BitAccessor accessor) {
        this.accessor = accessor;
    }

    public BigBitSet(BitSet bitSet) {
        this();
        this.bitSet = bitSet;
    }

    public BigBitSet(BitAccessor accessor, BitSet bitSet) {
        this.accessor = accessor;
        this.bitSet = bitSet;
    }

    public BigBitSet(byte[] value) {
        this();
        this.bitSet = BitSet.valueOf(value);
    }

    public BigBitSet(BitAccessor accessor, byte[] value) {
        this.accessor = accessor;
        this.bitSet = BitSet.valueOf(value);
    }

    public BigBitSet(Collection<T> items) {
        this();
        this.addAll(items);
    }

    public BigBitSet(BitAccessor accessor, Collection<T> items) {
        this.accessor = accessor;
        this.addAll(items);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Objects.hashCode(this.bitSet);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigBitSet other = (BigBitSet)obj;
        return Objects.equals(this.bitSet, other.bitSet);
    }

    private Class<T> getParamClass(int pos) {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[pos];
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }

    public byte[] toByteArray() {
        return this.bitSet != null ? this.bitSet.toByteArray() : null;
    }

    public void setBitSet(BitSet bitSet) {
        this.bitSet = bitSet;
    }

    public boolean contains(T item) {
        return this.bitSet != null && this.bitSet.get(this.accessor.getBitNum(item));
    }

    public boolean containsAll(Collection<T> items) {
        Boolean res = items.stream().map(this::contains).reduce((c1, c2) -> c1 != false && c2 != false).orElse(Boolean.FALSE);
        return res;
    }

    public boolean containsAll(T ... items) {
        return Stream.of(items).map(this::contains).reduce((c1, c2) -> c1 != false && c2 != false).orElse(Boolean.FALSE);
    }

    public boolean containsAny(Collection<T> items) {
        return items.stream().map(this::contains).reduce((c1, c2) -> c1 != false || c2 != false).orElse(Boolean.FALSE);
    }

    public boolean containsAny(T ... items) {
        return Stream.of(items).map(this::contains).reduce((c1, c2) -> c1 != false || c2 != false).orElse(Boolean.FALSE);
    }

    public boolean remove(T item) {
        boolean res = false;
        if (this.bitSet != null) {
            int bitNum = this.accessor.getBitNum(item);
            res = this.bitSet.get(bitNum);
            this.bitSet.clear(bitNum);
        }
        return res;
    }

    public void add(T item) {
        if (this.bitSet == null) {
            this.bitSet = new BitSet();
        }
        int bitNum = this.accessor.getBitNum(item);
        this.bitSet.set(bitNum);
    }

    public void set(T item, boolean value) {
        if (this.bitSet == null) {
            this.bitSet = new BitSet();
        }
        int bitNum = this.accessor.getBitNum(item);
        this.bitSet.set(bitNum, value);
    }

    public final void addAll(Collection<T> items) {
        items.forEach(this::add);
    }

    public void removeAll(Collection<T> items) {
        items.forEach(this::remove);
    }

    public List<Integer> getSetBits() {
        ArrayList<Integer> res = this.bitSet != null ? this.bitSet.stream().boxed().collect(Collectors.toList()) : new ArrayList<Integer>();
        return res;
    }
}

