/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.converters;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.sessions.Session;

public class UUIDConverterUniversal
implements Converter {
    private Boolean isUUIDasByteArray = true;

    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        if (this.isUUIDasByteArray.booleanValue()) {
            UUID uuid = (UUID)objectValue;
            if (uuid == null) {
                return null;
            }
            byte[] buffer = new byte[16];
            ByteBuffer bb = ByteBuffer.wrap(buffer);
            bb.putLong(uuid.getMostSignificantBits());
            bb.putLong(uuid.getLeastSignificantBits());
            return buffer;
        }
        return objectValue;
    }

    public UUID convertDataValueToObjectValue(Object dataValue, Session session) {
        if (this.isUUIDasByteArray.booleanValue()) {
            byte[] bytes = (byte[])dataValue;
            if (bytes == null) {
                return null;
            }
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            long high = bb.getLong();
            long low = bb.getLong();
            return new UUID(high, low);
        }
        return (UUID)dataValue;
    }

    public boolean isMutable() {
        return true;
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        DatabaseField field = mapping instanceof DirectCollectionMapping ? ((DirectCollectionMapping)mapping).getDirectField() : mapping.getField();
        if (session != null && session.getLogin() != null && session.getLogin().getPlatform() != null) {
            String platform;
            switch (platform = session.getLogin().getPlatform().getClass().getSimpleName()) {
                case "PostgreSQLPlatform": {
                    field.setSqlType(1111);
                    field.setTypeName("java.util.UUID");
                    field.setColumnDefinition("UUID");
                    this.isUUIDasByteArray = false;
                    break;
                }
                case "H2Platform": {
                    field.setColumnDefinition("UUID");
                    break;
                }
                case "OraclePlatform": {
                    field.setColumnDefinition("RAW(16)");
                    break;
                }
                case "MySQLPlatform": {
                    field.setColumnDefinition("BINARY(16)");
                    break;
                }
                case "SQLServerPlatform": {
                    field.setColumnDefinition("UNIQUEIDENTIFIER");
                    break;
                }
            }
        }
    }
}

