/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.jpa.jaxb;

import com.sun.xml.internal.bind.AccessorFactory;
import com.sun.xml.internal.bind.v2.runtime.reflect.Accessor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sessions.Session;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.transaction.annotation.Transactional;
import ru.ilb.common.jpa.jaxb.LazyCustomFieldAccessor;

@Configurable
public class LazyAccessorFactoryImpl
implements AccessorFactory {
    @Resource
    protected EntityManager entityManager;

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Transactional
    public Accessor createFieldAccessor(Class bean, Field field, boolean readOnly) {
        DatabaseMapping dm;
        ClassDescriptor cd = ((Session)this.entityManager.unwrap(Session.class)).getDescriptor(bean);
        DatabaseMapping databaseMapping = dm = cd != null ? cd.getMappingForAttributeName(field.getName()) : null;
        if (dm != null && dm.isLazy()) {
            return new LazyCustomFieldAccessor(bean, field);
        }
        return readOnly ? new Accessor.ReadOnlyFieldReflection(field) : new Accessor.FieldReflection(field);
    }

    public Accessor createPropertyAccessor(Class bean, Method getter, Method setter) {
        if (getter == null) {
            return new Accessor.SetterOnlyReflection(setter);
        }
        if (setter == null) {
            return new Accessor.GetterOnlyReflection(getter);
        }
        return new Accessor.GetterSetterReflection(getter, setter);
    }
}

