/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.lock;

import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import ru.ilb.common.lock.StampedLockFactory;

public class LockedExecutor {
    private final StampedLockFactory<String> lockFactory;

    public LockedExecutor() {
        this.lockFactory = new StampedLockFactory();
    }

    public LockedExecutor(StampedLockFactory<String> lockFactory) {
        this.lockFactory = lockFactory;
    }

    public void execute(String lockKey, Checker check, Builder execute) {
        this.execute(() -> this.lockFactory.getLock(lockKey), check, execute);
    }

    public void execute(Supplier<StampedLock> lockSupplier, Checker checker, Builder builder) {
        StampedLock lock = lockSupplier.get();
        long stamp = lock.readLock();
        try {
            if (!checker.valid()) {
                if ((stamp = lock.tryConvertToWriteLock(stamp)) == 0L) {
                    stamp = lock.writeLock();
                }
                builder.run();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            lock.unlock(stamp);
        }
    }

    @FunctionalInterface
    public static interface Builder {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface Checker {
        public boolean valid() throws Exception;
    }
}

