/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.openapi.generator;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;

public class ModelConverterImpl
implements ModelConverter {
    static final Logger LOG = Logger.getLogger(ModelConverterImpl.class.getName());
    private final List<String> ignorePackage;

    public ModelConverterImpl() {
        Properties properties = this.loadProperties();
        String ignorePackageStr = properties.getProperty("ignorePackage");
        if (ignorePackageStr != null && !ignorePackageStr.trim().isEmpty()) {
            this.ignorePackage = Arrays.asList(ignorePackageStr.trim().split(","));
            LOG.log(Level.INFO, "ignorePackage={0}", this.ignorePackage);
        } else {
            this.ignorePackage = null;
        }
    }

    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Class cls;
        JavaType _type;
        if (this.ignorePackage != null && type.isSchemaProperty() && (_type = Json.mapper().constructType(type.getType())) != null && (cls = _type.getRawClass()).getPackage() != null && this.ignorePackage.stream().anyMatch(s -> s.contains(cls.getPackage().getName()))) {
            return null;
        }
        Multipart multipart = (Multipart)AnnotationsUtils.getAnnotation(Multipart.class, (Annotation[])type.getCtxAnnotations());
        if (multipart != null) {
            Schema schema = chain.next().resolve(type, context, chain);
            schema.setType("object");
            schema.setFormat(null);
            schema.addProperties(multipart.value(), new Schema().type("string").format("binary"));
            return schema;
        }
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }

    private Properties loadProperties() {
        Properties props = new Properties();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("common-openapi.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return props;
    }
}

