/*
 * Copyright 2016 Bystrobank
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ru.ilb.common.spring;

import java.util.Properties;
import javax.naming.NamingException;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.jndi.JndiTemplate;

/**
 *
 * @author slavb
 */
public class JndiPropertyPlaceholderConfigurer extends PropertyPlaceholderConfigurer {

    private String jndiPrefix = "";
    private JndiTemplate jndiTemplate = new JndiTemplate();

    @Override
    protected String resolvePlaceholder(String placeholder, Properties props) {
        String value = null;
        value = resolveJndiPlaceholder(placeholder);
        if (value == null) {
            value = super.resolvePlaceholder(placeholder, props);
        }
        return value;
    }

    private String resolveJndiPlaceholder(String placeholder) {
        try {
            String value = (String)jndiTemplate.lookup(jndiPrefix + placeholder, String.class);
            return value;
        } catch (NamingException e) {
            throw new RuntimeException(e);
        }
        //return null;
    }

    public void setJndiPrefix(String jndiPrefix) {
        this.jndiPrefix = jndiPrefix;
    }

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiTemplate = jndiTemplate;
    }
}