/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.spring;

import java.util.Properties;
import javax.naming.NamingException;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.jndi.JndiTemplate;

public class JndiPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private String jndiPrefix = "";
    private JndiTemplate jndiTemplate = new JndiTemplate();

    protected String resolvePlaceholder(String placeholder, Properties props) {
        String value = null;
        value = this.resolveJndiPlaceholder(placeholder);
        if (value == null) {
            value = super.resolvePlaceholder(placeholder, props);
        }
        return value;
    }

    private String resolveJndiPlaceholder(String placeholder) {
        try {
            String value = (String)this.jndiTemplate.lookup(this.jndiPrefix + placeholder, String.class);
            return value;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void setJndiPrefix(String jndiPrefix) {
        this.jndiPrefix = jndiPrefix;
    }

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiTemplate = jndiTemplate;
    }
}

