/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.springboot;

import java.util.Arrays;
import javax.xml.transform.URIResolver;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.jaxrs.provider.XSLTJaxbProvider;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import ru.ilb.common.jaxrs.async.AsyncTaskManager;
import ru.ilb.common.jaxrs.jaxb.JaxbContextResolver;
import ru.ilb.common.jaxrs.json.MOXyJsonProvider;
import ru.ilb.common.jaxrs.xml.transform.ServletContextURIResolver;
import ru.ilb.common.springboot.ILBProperties;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={ILBProperties.class})
@ConditionalOnClass(value={SpringBus.class, CXFServlet.class})
@AutoConfigureAfter(name={"org.apache.cxf.spring.boot.autoconfigure.CxfAutoConfiguration"})
public class ILBAutoConfiguration {
    @Autowired
    ILBProperties properties;
    @Autowired
    Environment env;

    @Bean
    @ConditionalOnMissingBean
    public MOXyJsonProvider jsonProvider() {
        return new MOXyJsonProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public JaxbContextResolver jaxbContextResolver() {
        return new JaxbContextResolver();
    }

    @Bean
    @ConditionalOnMissingBean
    AsyncTaskManager asyncTaskManager() {
        return new AsyncTaskManager();
    }

    @Bean
    @ConditionalOnMissingBean
    public XSLTJaxbProvider xsltJaxbProvider(@Value(value="${refreshTemplates:false}") Boolean refreshTemplates) {
        XSLTJaxbProvider xsltJaxbProvider = new XSLTJaxbProvider();
        xsltJaxbProvider.setResolver((URIResolver)new ServletContextURIResolver());
        xsltJaxbProvider.setProduceMediaTypes(Arrays.asList(this.properties.getXslt().getProduces()));
        xsltJaxbProvider.setSecureProcessing(this.properties.getXslt().getSecureProcessing().booleanValue());
        xsltJaxbProvider.setRefreshTemplates(refreshTemplates.booleanValue());
        return xsltJaxbProvider;
    }
}

