
package com.sun.java.xml.ns.javaee;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 * 
 *         The filterType is used to declare a filter in the web
 *         application. The filter is mapped to either a servlet or a
 *         URL pattern in the filter-mapping element, using the
 *         filter-name value to reference. Filters can access the
 *         initialization parameters declared in the deployment
 *         descriptor at runtime via the FilterConfig interface.
 *         
 *         Used in: web-app
 *         
 *       
 * 
 * <p>Java class for filterType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="filterType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;group ref="{http://java.sun.com/xml/ns/javaee}descriptionGroup"/&gt;
 *         &lt;element name="filter-name" type="{http://java.sun.com/xml/ns/javaee}filter-nameType"/&gt;
 *         &lt;element name="filter-class" type="{http://java.sun.com/xml/ns/javaee}fully-qualified-classType" minOccurs="0"/&gt;
 *         &lt;element name="async-supported" type="{http://java.sun.com/xml/ns/javaee}true-falseType" minOccurs="0"/&gt;
 *         &lt;element name="init-param" type="{http://java.sun.com/xml/ns/javaee}param-valueType" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}ID" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "filterType", propOrder = {
    "description",
    "displayName",
    "icon",
    "filterName",
    "filterClass",
    "asyncSupported",
    "initParam"
})
public class FilterType {

    protected List<DescriptionType> description;
    @XmlElement(name = "display-name")
    protected List<DisplayNameType> displayName;
    protected List<IconType> icon;
    @XmlElement(name = "filter-name", required = true)
    protected FilterNameType filterName;
    @XmlElement(name = "filter-class")
    protected FullyQualifiedClassType filterClass;
    @XmlElement(name = "async-supported")
    protected TrueFalseType asyncSupported;
    @XmlElement(name = "init-param")
    protected List<ParamValueType> initParam;
    @XmlAttribute(name = "id")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    protected java.lang.String id;

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * 
     * 
     */
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<DescriptionType>();
        }
        return this.description;
    }

    /**
     * Gets the value of the displayName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the displayName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDisplayName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DisplayNameType }
     * 
     * 
     */
    public List<DisplayNameType> getDisplayName() {
        if (displayName == null) {
            displayName = new ArrayList<DisplayNameType>();
        }
        return this.displayName;
    }

    /**
     * Gets the value of the icon property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the icon property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIcon().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IconType }
     * 
     * 
     */
    public List<IconType> getIcon() {
        if (icon == null) {
            icon = new ArrayList<IconType>();
        }
        return this.icon;
    }

    /**
     * Gets the value of the filterName property.
     * 
     * @return
     *     possible object is
     *     {@link FilterNameType }
     *     
     */
    public FilterNameType getFilterName() {
        return filterName;
    }

    /**
     * Sets the value of the filterName property.
     * 
     * @param value
     *     allowed object is
     *     {@link FilterNameType }
     *     
     */
    public void setFilterName(FilterNameType value) {
        this.filterName = value;
    }

    /**
     * Gets the value of the filterClass property.
     * 
     * @return
     *     possible object is
     *     {@link FullyQualifiedClassType }
     *     
     */
    public FullyQualifiedClassType getFilterClass() {
        return filterClass;
    }

    /**
     * Sets the value of the filterClass property.
     * 
     * @param value
     *     allowed object is
     *     {@link FullyQualifiedClassType }
     *     
     */
    public void setFilterClass(FullyQualifiedClassType value) {
        this.filterClass = value;
    }

    /**
     * Gets the value of the asyncSupported property.
     * 
     * @return
     *     possible object is
     *     {@link TrueFalseType }
     *     
     */
    public TrueFalseType getAsyncSupported() {
        return asyncSupported;
    }

    /**
     * Sets the value of the asyncSupported property.
     * 
     * @param value
     *     allowed object is
     *     {@link TrueFalseType }
     *     
     */
    public void setAsyncSupported(TrueFalseType value) {
        this.asyncSupported = value;
    }

    /**
     * Gets the value of the initParam property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the initParam property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInitParam().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ParamValueType }
     * 
     * 
     */
    public List<ParamValueType> getInitParam() {
        if (initParam == null) {
            initParam = new ArrayList<ParamValueType>();
        }
        return this.initParam;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link java.lang.String }
     *     
     */
    public java.lang.String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link java.lang.String }
     *     
     */
    public void setId(java.lang.String value) {
        this.id = value;
    }

    public FilterType withDescription(DescriptionType... values) {
        if (values!= null) {
            for (DescriptionType value: values) {
                getDescription().add(value);
            }
        }
        return this;
    }

    public FilterType withDescription(Collection<DescriptionType> values) {
        if (values!= null) {
            getDescription().addAll(values);
        }
        return this;
    }

    public FilterType withDisplayName(DisplayNameType... values) {
        if (values!= null) {
            for (DisplayNameType value: values) {
                getDisplayName().add(value);
            }
        }
        return this;
    }

    public FilterType withDisplayName(Collection<DisplayNameType> values) {
        if (values!= null) {
            getDisplayName().addAll(values);
        }
        return this;
    }

    public FilterType withIcon(IconType... values) {
        if (values!= null) {
            for (IconType value: values) {
                getIcon().add(value);
            }
        }
        return this;
    }

    public FilterType withIcon(Collection<IconType> values) {
        if (values!= null) {
            getIcon().addAll(values);
        }
        return this;
    }

    public FilterType withFilterName(FilterNameType value) {
        setFilterName(value);
        return this;
    }

    public FilterType withFilterClass(FullyQualifiedClassType value) {
        setFilterClass(value);
        return this;
    }

    public FilterType withAsyncSupported(TrueFalseType value) {
        setAsyncSupported(value);
        return this;
    }

    public FilterType withInitParam(ParamValueType... values) {
        if (values!= null) {
            for (ParamValueType value: values) {
                getInitParam().add(value);
            }
        }
        return this;
    }

    public FilterType withInitParam(Collection<ParamValueType> values) {
        if (values!= null) {
            getInitParam().addAll(values);
        }
        return this;
    }

    public FilterType withId(java.lang.String value) {
        setId(value);
        return this;
    }

}
