/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.common.test;

import com.sun.java.xml.ns.javaee.EnvEntryType;
import com.sun.java.xml.ns.javaee.ResourceEnvRefType;
import com.sun.java.xml.ns.javaee.ResourceRefType;
import com.sun.java.xml.ns.javaee.WebAppType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import ru.ilb.common.jaxb.util.JaxbUtil;

public abstract class Jndi {
    protected JAXBContext jaxbContext;
    private WebAppType webApp;
    private Map<String, Object> params = new HashMap<String, Object>();
    private final List<String> entryList = Arrays.asList("env-entry", "resource-ref", "resource-env-ref");
    protected List<String> excludeNames = new ArrayList<String>();

    public final WebAppType getWebApp() {
        if (this.webApp != null) {
            return this.webApp;
        }
        try {
            this.jaxbContext = JAXBContext.newInstance((String)"com.sun.java.xml.ns.javaee");
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
        try {
            String xml = new String(Files.readAllBytes(Paths.get("src/main/webapp/WEB-INF/web.xml", new String[0])));
            this.webApp = (WebAppType)JaxbUtil.unmarshal((JAXBContext)this.jaxbContext, (String)xml, WebAppType.class, (String)"application/xml");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return this.webApp;
    }

    protected List<String> getExcludeNames() {
        return this.excludeNames;
    }

    protected void addExcludeName(String name) {
        this.excludeNames.add(name);
    }

    protected Map<String, Object> getParams() {
        if (!this.params.isEmpty()) {
            return this.params;
        }
        this.getWebApp().getModuleNameOrDescriptionAndDisplayName().stream().filter(el -> this.entryList.contains(el.getName().getLocalPart())).forEach(el -> {
            String name = null;
            Object value = null;
            if (el.getValue() instanceof EnvEntryType) {
                name = ((EnvEntryType)el.getValue()).getEnvEntryName().getValue();
                value = this.getEnvEntryValue((EnvEntryType)el.getValue());
            } else if (el.getValue() instanceof ResourceRefType) {
                name = ((ResourceRefType)el.getValue()).getResRefName().getValue();
                value = this.getResourceRefValue((ResourceRefType)el.getValue());
            } else if (el.getValue() instanceof ResourceEnvRefType) {
                name = ((ResourceEnvRefType)el.getValue()).getResourceEnvRefName().getValue();
                value = this.getResourceEnvRefValue((ResourceEnvRefType)el.getValue());
            }
            if (name != null && !this.excludeNames.contains(name)) {
                this.params.put(name, value);
            }
        });
        return this.params;
    }

    protected Object getEnvEntryValue(EnvEntryType envEntryType) {
        switch (envEntryType.getEnvEntryType().getValue()) {
            case "java.lang.Boolean": {
                return Boolean.valueOf(envEntryType.getEnvEntryValue().getValue());
            }
            case "java.lang.Integer": {
                return Integer.valueOf(envEntryType.getEnvEntryValue().getValue());
            }
            case "java.lang.Double": {
                return Double.valueOf(envEntryType.getEnvEntryValue().getValue());
            }
            case "java.lang.Long": {
                return Long.valueOf(envEntryType.getEnvEntryValue().getValue());
            }
        }
        return envEntryType.getEnvEntryValue().getValue();
    }

    protected Object getResourceRefValue(ResourceRefType resourceRefType) {
        return "";
    }

    protected Object getResourceEnvRefValue(ResourceEnvRefType resourceEnvRefType) {
        return "";
    }
}

