/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.containeraccessor.components;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import ru.ilb.containeraccessor.components.ContainerResource;
import ru.ilb.containeraccessor.components.ContainerResourceIndexJson;
import ru.ilb.containeraccessor.core.ContainerAccessor;
import ru.ilb.containeraccessor.core.ContainerAccessorFactory;
import ru.ilb.uriaccessor.URIAccessor;
import ru.ilb.uriaccessor.URIAccessorFactory;
import ru.ilb.uriaccessor.URIStorage;

public class ContainerResourceImpl
implements ContainerResource {
    private final UriInfo uriInfo;
    private final URI uri;
    private final URIAccessor uriAccessor;
    private final URIStorage uriStorage;
    URIAccessorFactory uriAccessorFactory = new URIAccessorFactory();
    private final ContainerAccessorFactory caf = new ContainerAccessorFactory();
    private final ContainerAccessor containerAccessor;

    public ContainerResourceImpl(UriInfo uriInfo, URI uri, URIStorage uriStorage) {
        this.uriInfo = uriInfo;
        this.uri = uri;
        this.uriAccessor = this.uriAccessorFactory.getURIAccessor(uri);
        this.uriStorage = uriStorage;
        this.containerAccessor = this.caf.getContainerAccessor(this.uriAccessor);
    }

    @Override
    public Response get(String accept) {
        return Response.ok((Object)this.uriAccessor.getContent()).header("Content-Type", (Object)this.uriAccessor.getContentType()).build();
    }

    @Override
    public ContainerResource subResource(String name) {
        try {
            Path path = this.containerAccessor.getContentsPath().resolve(name);
            if (Files.exists(path, new LinkOption[0])) {
                return new ContainerResourceImpl(this.uriInfo, path.toUri(), this.uriStorage);
            }
            if ("index".equals(name)) {
                return new ContainerResourceIndexJson(this.uri, this.uriStorage);
            }
            throw new NotFoundException(name + " not found");
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }
}

