/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.containeraccessor.components;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import ru.ilb.containeraccessor.components.ContainerResource;
import ru.ilb.containeraccessor.core.ContainerAccessor;
import ru.ilb.containeraccessor.core.ContainerAccessorFactory;
import ru.ilb.containeraccessor.mapper.FileMapper;
import ru.ilb.containeraccessor.mapper.FileMapperJson;
import ru.ilb.containeraccessor.model.File;
import ru.ilb.uriaccessor.URIAccessor;
import ru.ilb.uriaccessor.URIAccessorFactory;
import ru.ilb.uriaccessor.URIStorage;

public class ContainerResourceIndexJson
implements ContainerResource {
    private final FileMapper fileMapper = new FileMapperJson();
    private final URI uri;
    private final URIAccessor uriAccessor;
    private final URIStorage uriStorage;
    URIAccessorFactory uriAccessorFactory = new URIAccessorFactory();
    private final ContainerAccessorFactory caf = new ContainerAccessorFactory();
    private final ContainerAccessor containerAccessor;

    public ContainerResourceIndexJson(URI uri, URIStorage uriStorage) {
        this.uri = uri;
        this.uriAccessor = this.uriAccessorFactory.getURIAccessor(uri);
        this.uriStorage = uriStorage;
        this.containerAccessor = this.caf.getContainerAccessor(this.uriAccessor);
    }

    @Override
    public Response get(String accept) throws IOException {
        if (accept != null && !accept.startsWith("application/json")) {
            throw new WebApplicationException("MediaType " + accept + " not supported");
        }
        ArrayList files = new ArrayList();
        Files.list(this.containerAccessor.getContentsPath()).sorted().forEach(x -> {
            File file = new File();
            file.setName(x.getFileName().toString());
            LocalDateTime date = Instant.ofEpochSecond(x.toFile().lastModified() / 1000L).atZone(ZoneId.systemDefault()).toLocalDateTime();
            file.setLastModified(date);
            file.setSize(x.toFile().length());
            files.add(file);
        });
        String json = this.fileMapper.marshall(files);
        return Response.ok((Object)json, (String)"application/json").build();
    }

    @Override
    public ContainerResource subResource(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

